% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tools.R
\name{.f_label}
\alias{.f_label}
\title{Internal helper: pretty label lookup}
\usage{
.f_label(colname, lookup = ume::nice_labels_dt)
}
\arguments{
\item{colname}{Character string. Column name to be matched.}

\item{lookup}{A \code{data.table} or \code{data.frame} with columns
\code{name_pattern} and \code{name_substitute}.}
}
\value{
A character string: either the substitute label or the original
\code{colname} if no pattern matches.
}
\description{
Internal utility function to map a variable or column name to a more
descriptive, human-readable label based on a lookup table.

The lookup table must contain two columns:
\itemize{
\item \code{name_pattern}    – Regular expressions to match column names
\item \code{name_substitute} – Human-readable label returned when pattern matches
}

The function returns the first matching substitute label.
If no pattern matches, the input \code{colname} is returned unchanged.

This function is not exported and is intended for use inside the \code{ume}
package (e.g., for automatic axis labeling in plotting functions).
}
\details{
Lookup Pretty Labels for Column Names (Internal)
}
\keyword{internal}
