% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/uis_get.R
\name{uis_get}
\alias{uis_get}
\title{Get data from the UIS API}
\usage{
uis_get(
  entities = NULL,
  indicators = NULL,
  start_year = NULL,
  end_year = NULL,
  version = NULL
)
}
\arguments{
\item{entities}{Character vector. The entity IDs (ISO 3166-1 alpha-3 codes)
to retrieve data for. Must provide either this parameter or \code{indicators} or
both. See \link{uis_get_entities} for a list of supported entities.}

\item{indicators}{Character vector. The indicator IDs to retrieve data for.
Must provide either this parameter or \code{entities} or both. See
\link{uis_get_indicators} for a list of supported indicators.}

\item{start_year}{Numeric or character. The starting year for the data
retrieval period. If NULL, no start year constraint is applied.}

\item{end_year}{Numeric or character. The ending year for the data retrieval
period. If NULL, no end year constraint is applied.}

\item{version}{Character. The API version to use. If NULL, the default
version is used. See \link{uis_get_versions} for a list of supported
versions.}
}
\value{
A data frame with the following columns:
\item{entity_id}{Character. The ID of the entity (geoUnit).}
\item{indicator_id}{Character. The ID of the indicator.}
\item{year}{Numeric. The year of the observation.}
\item{value}{Numeric. The value of the indicator for the given entity and
year.}
}
\description{
Retrieves data from the UNESCO Institute for Statistics (UIS) API for
specified entities, indicators, and time periods.
}
\examples{
\dontshow{if (curl::has_internet()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
\donttest{
# Get all data for a single indicator
uis_get(
  indicators = "CR.1"
)

# Get all data for a single country
uis_get(
  entities = "BRA"
)

# Get data for multiple indicators and countries
uis_get(
  entities = c("BRA", "USA"),
  indicators = c("CR.1", "CR.2")
)

# Get data for multiple indicators and countries and specific time range
uis_get(
  entities = c("BRA", "USA"),
  indicators = c("CR.1", "CR.2"),
  start_year = 2010,
  end_year = 2020
)
}
\dontshow{\}) # examplesIf}
}
