% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transforms-generics.R
\name{transform_to_tensor}
\alias{transform_to_tensor}
\title{Convert an image to a tensor}
\usage{
transform_to_tensor(img)
}
\arguments{
\item{img}{A \code{magick-image}, \code{array} or \code{torch_tensor}.}
}
\description{
Converts a Magick Image or array (H x W x C) in the range \verb{[0, 255]} to a
\code{torch_tensor} of shape (C x H x W) in the range \verb{[0.0, 1.0]}. In the
other cases, tensors are returned without scaling.
}
\note{
Because the input image is scaled to \verb{[0.0, 1.0]}, this transformation
should not be used when transforming target image masks.
}
\seealso{
Other unitary_transforms: 
\code{\link{transform_adjust_brightness}()},
\code{\link{transform_adjust_contrast}()},
\code{\link{transform_adjust_gamma}()},
\code{\link{transform_adjust_hue}()},
\code{\link{transform_adjust_saturation}()},
\code{\link{transform_affine}()},
\code{\link{transform_center_crop}()},
\code{\link{transform_convert_image_dtype}()},
\code{\link{transform_crop}()},
\code{\link{transform_grayscale}()},
\code{\link{transform_hflip}()},
\code{\link{transform_linear_transformation}()},
\code{\link{transform_normalize}()},
\code{\link{transform_pad}()},
\code{\link{transform_perspective}()},
\code{\link{transform_resize}()},
\code{\link{transform_rgb_to_grayscale}()},
\code{\link{transform_rotate}()},
\code{\link{transform_vflip}()}
}
\concept{unitary_transforms}
