% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transforms-generics.R
\name{transform_adjust_hue}
\alias{transform_adjust_hue}
\title{Adjust the hue of an image}
\usage{
transform_adjust_hue(img, hue_factor)
}
\arguments{
\item{img}{A \code{magick-image}, \code{array} or \code{torch_tensor}.}

\item{hue_factor}{(float):  How much to shift the hue channel. Should be in
\verb{[-0.5, 0.5]}. 0.5 and -0.5 give complete reversal of hue channel in
HSV space in positive and negative direction respectively.
0 means no shift. Therefore, both -0.5 and 0.5 will give an image
with complementary colors while 0 gives the original image.}
}
\description{
The image hue is adjusted by converting the image to HSV and
cyclically shifting the intensities in the hue channel (H).
The image is then converted back to original image mode.
}
\details{
\code{hue_factor} is the amount of shift in H channel and must be in the
interval \verb{[-0.5, 0.5]}.

Search for Hue for more details.
}
\seealso{
Other unitary_transforms: 
\code{\link{transform_adjust_brightness}()},
\code{\link{transform_adjust_contrast}()},
\code{\link{transform_adjust_gamma}()},
\code{\link{transform_adjust_saturation}()},
\code{\link{transform_affine}()},
\code{\link{transform_center_crop}()},
\code{\link{transform_convert_image_dtype}()},
\code{\link{transform_crop}()},
\code{\link{transform_grayscale}()},
\code{\link{transform_hflip}()},
\code{\link{transform_linear_transformation}()},
\code{\link{transform_normalize}()},
\code{\link{transform_pad}()},
\code{\link{transform_perspective}()},
\code{\link{transform_resize}()},
\code{\link{transform_rgb_to_grayscale}()},
\code{\link{transform_rotate}()},
\code{\link{transform_to_tensor}()},
\code{\link{transform_vflip}()}
}
\concept{unitary_transforms}
