% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pro.R
\name{with_pro}
\alias{with_pro}
\alias{aes_pro}
\title{Standard Evaluated Versions of Some Common Expression-Evaluation Functions}
\usage{
with_pro(data, form)

aes_pro(...)
}
\arguments{
\item{data}{a list, environment, or data.frame.}

\item{form}{a one-sided formula giving the expression to evaluate in \code{with_pro}. \cr
If the formula has an environment,
that environment is used to find any variables or objects not present in \code{data}.}

\item{...}{arguments to be passed to \code{ggplot2::}\link[ggplot2]{aes},
but given as one-sided formulas.}
}
\value{
For \code{with_pro()}: see \link[base]{with}. \cr
For \code{aes_pro()}: see \code{ggplot2::}\link[ggplot2]{aes}. \cr \cr
}
\description{
The \code{with_pro()} and \code{aes_pro()} functions
are standard-evaluated versions of the expression-evaluation functions
\link[base]{with} and \code{ggplot2::}\link[ggplot2]{aes},
respectively. \cr
\cr
These alternative functions are more programmatically friendly: \cr
They use proper standard evaluation,
through the usage of one-sided formulas,
instead of non-standard evaluation,
tidy evaluation,
or similar programmatically unfriendly evaluations. \cr \cr
}
\details{
The \code{aes_pro()} function is the standard evaluated alternative to
\code{ggplot2::}\link[ggplot2]{aes}. \cr
Due to the way \code{aes_pro()} is programmed,
it should work even if the tidy evaluation technique
changes in 'ggplot2'. \cr
To support functions in combinations with references of the variables,
the input used here are formula inputs, rather than string inputs. \cr
See the Examples section below. \cr \cr
}
\note{
The \code{with_pro()} function, like the original \link[base]{with} function,
is made for primarily for convenience. \cr
When using modelling or graphics functions with an explicit \code{data} argument
(and typically using \link[stats]{formula}s),
it is typically preferred to use the \code{data} argument of that function,
rather than to use either \cr
\code{with(data, ...)} or \code{with_pro(data, ...)}. \cr \cr
}
\section{Non-Standard Evaluation}{


Non-Standard Evaluation (sometimes abbreviated as "NSE"),
is somewhat controversial. \cr
Consider the following example:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{aplot <- "ggplot2"
library(aplot)
}\if{html}{\out{</div>}}

What package will be attached? It will not be 'ggplot2',
nor will an error occur.
Instead, the package 'aplot' will be attached. \cr
This is due to evaluating the expression 'aplot' as a quoted expression,
instead of evaluating the contents (i.e. string or formula) of the variable.
In other words: Non-Standard Evaluation. \cr
\cr
Regular Standard Evaluation does not have the above problem. \cr
}

\examples{
\dontshow{if (requireNamespace("ggplot2")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
requireNamespace("ggplot2")


d <- import_data("ggplot2", "mpg")

# mutate data:
myform <- ~ displ + cyl + cty + hwy
d$mysum <- with_pro(d, myform)
summary(d)

# plotting data:
x <- ~ cty
y <- ~ sqrt(hwy)
color <- ~ drv

ggplot2::ggplot(d, aes_pro(x, y, color = color)) +
  ggplot2::geom_point()



\dontshow{\}) # examplesIf}
}
\seealso{
\link{tinycodet_safer}
}
