% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/attr-nodes.R
\name{protect_fences}
\alias{protect_fences}
\title{Protect fences of Pandoc fences divs for further processing}
\usage{
protect_fences(body, ns = md_ns())
}
\arguments{
\item{body}{an XML object}

\item{ns}{an XML namespace object (defaults: \code{\link[=md_ns]{md_ns()}}).}
}
\value{
a copy of the modified XML object
}
\description{
Protect fences of Pandoc fences divs for further processing
}
\details{
Commonmark will render text such as \verb{::: footer}
as normal text which might be problematic if trying to extract
real text from the XML.

If sending the XML to, say, a translation API that allows some tags
to be ignored, you could first transform the text tags with the
attribute \code{fences} to \code{fences} tags, and then transform them back
to text tags before using \code{to_md()}.
}
\note{
this function is also a method in the \link{yarn} object.
}
\examples{
m <- tinkr::to_xml(system.file("extdata", "fenced-divs.md", package = "tinkr"))
xml2::xml_child(m$body)
m$body <- protect_fences(m$body)
xml2::xml_child(m$body)
}
