% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/time_seq.R
\name{time_seq}
\alias{time_seq}
\alias{time_seq_sizes}
\alias{time_seq_v}
\alias{time_seq_v2}
\title{Time based version of \code{base::seq()}}
\usage{
time_seq(
  from = NULL,
  to = NULL,
  time_by = NULL,
  length.out = NULL,
  roll_month = getOption("timeplyr.roll_month", "xlast"),
  roll_dst = getOption("timeplyr.roll_dst", c("NA", "xfirst"))
)

time_seq_sizes(from, to, timespan)

time_seq_v(
  from,
  to,
  timespan,
  roll_month = getOption("timeplyr.roll_month", "xlast"),
  roll_dst = getOption("timeplyr.roll_dst", c("NA", "xfirst"))
)

time_seq_v2(
  sizes,
  from,
  timespan,
  roll_month = getOption("timeplyr.roll_month", "xlast"),
  roll_dst = getOption("timeplyr.roll_dst", c("NA", "xfirst"))
)
}
\arguments{
\item{from}{Start time.}

\item{to}{End time.}

\item{time_by}{A \link{timespan}. This argument may be renamed in the future.}

\item{length.out}{Length of the sequence.}

\item{roll_month}{Control how impossible dates are handled when
month or year arithmetic is involved.
Options are "preday", "boundary", "postday", "full" and "NA".
See \code{?timechange::time_add} for more details.}

\item{roll_dst}{See \code{?timechange::time_add} for the full list of details.}

\item{timespan}{\link{timespan}.}

\item{sizes}{Time sequence sizes.}
}
\value{
\code{time_seq} returns a time sequence. \cr
\code{time_seq_sizes} returns an integer vector of sequence sizes. \cr
\code{time_seq_v} returns time sequences. \cr
\code{time_seq_v2} also returns time sequences.
}
\description{
Time based version of \code{base::seq()}
}
\details{
This works like \code{seq()},
but using \code{timechange} for the period calculations and
\code{base::seq.POSIXT()} for the duration calculations.
In many ways it is improved over \code{seq} as
dates and/or datetimes can be supplied with no errors to
the start and end points.
Examples like,\cr
\code{time_seq(now(), length.out = 10, by = "0.5 days", seq_type = "dur")}
and \cr
\code{time_seq(today(), length.out = 10, by = "0.5 days", seq_type = "dur")}\cr
produce more expected results compared to \cr
\code{seq(now(), length.out = 10, by = "0.5 days")} or \cr
\code{seq(today(), length.out = 10, by = "0.5 days")}.\cr

For a vectorized implementation with multiple start/end times,
use \code{time_seq_v()}/\code{time_seq_v2()}

\code{time_seq_sizes()} is a convenience
function to calculate time sequence lengths, given start/end times.
}
\examples{
library(timeplyr)
library(lubridate)
\dontshow{
.n_dt_threads <- data.table::getDTthreads()
.n_collapse_threads <- collapse::get_collapse()$nthreads
data.table::setDTthreads(threads = 1L)
collapse::set_collapse(nthreads = 1L)
}
# Dates
today <- today()
now <- now()

time_seq(today, today + months(1), time = "day")
time_seq(today, length.out = 10, time = "day")
time_seq(today, length.out = 10, time = "hour")

time_seq(today, today + months(1), time = timespan("days", 1)) # Alternative
time_seq(today, today + years(1), time = "week")
time_seq(today, today + years(1), time = "fortnight")
time_seq(today, today + years(1), time = "year")
time_seq(today, today + years(10), time = "year")
time_seq(today, today + years(100), time = "decade")

# Datetimes
time_seq(now, now + weeks(1), time = "12 hours")
time_seq(now, now + weeks(1), time = "day")
time_seq(now, now + years(1), time = "week")
time_seq(now, now + years(1), time = "fortnight")
time_seq(now, now + years(1), time = "year")
time_seq(now, now + years(10), time = "year")
time_seq(now, today + years(100), time = "decade")

# You can seamlessly mix dates and datetimes with no errors.
time_seq(now, today + days(3), time = "day")
time_seq(now, today + days(3), time = "hour")
time_seq(today, now + days(3), time = "day")
time_seq(today, now + days(3), time = "hour")

# Choose between durations or periods

start <- dmy(31012020)
# If time_type is left as is,
# periods are used for days, weeks, months and years.
time_seq(start, time = months(1), length.out = 12)
time_seq(start, time = dmonths(1), length.out = 12)
# Notice how strange base R version is.
seq(start, by = "month", length.out = 12)

# Roll forward or backward impossible dates

leap <- dmy(29022020) # Leap day
end <- dmy(01032021)
# 3 different options
time_seq(leap, to = end, time = "year",
         roll_month = "NA")
time_seq(leap, to = end, time = "year",
         roll_month = "postday")
time_seq(leap, to = end, time = "year",
         roll_month = getOption("timeplyr.roll_month", "xlast"))
\dontshow{
data.table::setDTthreads(threads = .n_dt_threads)
collapse::set_collapse(nthreads = .n_collapse_threads)
}
}
