% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FilterState-utils.R
\name{fetch_bs_color}
\alias{fetch_bs_color}
\title{Get hex code of the current Bootstrap theme color.}
\usage{
fetch_bs_color(color, alpha = NULL)
}
\arguments{
\item{color}{(\code{character(1)}) naming one of the available theme colors}

\item{alpha}{either a \code{numeric(1)} or \code{character(1)} specifying transparency
in the range of \code{0-1} or a hexadecimal value \code{00-ff}, respectively;
set to NULL to omit adding the alpha channel}
}
\value{
Named \code{character(1)} containing a hexadecimal color representation.
}
\description{
Determines the color specification for the currently active Bootstrap color theme and returns one queried color.
}
\examples{
fetch_bs_color <- getFromNamespace("fetch_bs_color", "teal.slice")
fetch_bs_color("primary")
fetch_bs_color("danger", 0.35)
fetch_bs_color("danger", "80")

}
\keyword{internal}
