% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/server.R
\name{sd_show_if}
\alias{sd_show_if}
\title{Define show conditions for survey questions and pages}
\usage{
sd_show_if(...)
}
\arguments{
\item{...}{One or more formulas defining show conditions.
The left-hand side of each formula should be a condition based on input values,
and the right-hand side should be the ID of the question or page to show if the condition is met.}
}
\value{
A list of parsed conditions, where each element contains the condition and the target question or page ID.
Returns \code{NULL} if no conditions are provided.
}
\description{
This function is used to define conditions under which certain questions or pages in the survey should be shown.
It takes one or more formulas where the left-hand side is the condition and the right-hand side is the target question ID or page ID.
If called with no arguments, it will return \code{NULL} and set no conditions.
}
\examples{
if (interactive()) {
  library(surveydown)

  # Use sd_show_if() to conditionally show/hide questions:
  # server <- function(input, output, session) {
  #   sd_show_if(
  #     input$has_car == "yes" ~ "car_make",
  #     input$employed == "yes" ~ "job_title",
  #     input$age >= 18 ~ "adult_questions_page"
  #   )
  #   sd_server()
  # }

  # Find a working directory and start from a template:
  sd_create_survey(template = "conditional_showing")
  # This creates survey.qmd and app.R - launch the survey using app.R
}

}
\seealso{
\code{sd_skip_if()}
}
