% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ahreg.R
\name{ahreg}
\alias{ahreg}
\title{Regression Analysis with Average Hazard}
\usage{
ahreg(formula, tau, data, link="log", conf.int=0.95, 
             cens_strata=NULL, cens_covs=NULL)
}
\arguments{
\item{formula}{A formula object, with the response on the left of a ~ operator, and the terms on the right. The response must be a survival object as returned by the Surv function. For a multi-state model the formula may be a list of formulas.}

\item{tau}{A scalar value to specify a time point for calculating the average hazard.}

\item{data}{A data.frame in which to interpret the variables named in the formula.}

\item{link}{A link function to be used, either "log" (default) or "identity".}

\item{conf.int}{A confidence coefficient for calculating confidence intervals. The default is \code{conf.int=0.95}.}

\item{cens_strata}{A variable name for specifying group-specific censoring. Only one of \code{cens_strata} or \code{cens_cov} can be specified. The default is \code{NULL}.}

\item{cens_covs}{A set of variable names used for modeling censoring time distribution. Only one of \code{cens_strata} or \code{cens_covs} can be specified. The default is \code{NULL}.}
}
\value{
an object of class ahreg.

\item{result}{A table containing the coefficient estimates, standard errors, confidence intervals, z-values, and two-sided p-values for each predicotor.}
}
\description{
The \code{ahreg} function performs a regression analysis for the average hazard (AH).
}
\details{
The function implements the average hazard regression.
}
\examples{
#================================================================================
# ahreg.sample.data: Sample data from the pbc data in the survival package
#================================================================================
D = ahreg.sample.data()


#-- Independent censoring
a1 = ahreg(Surv(time,status) ~ arm + edema + bili, tau=7, data=D)
print(a1)

#-- Group specific censoring
a2 = ahreg(Surv(time,status) ~ arm + edema + bili, tau=7, data=D, cens_strata="arm")
print(a2)

#-- Covariate dependent censoring via Cox 
a3 = ahreg(Surv(time,status) ~ arm + edema + bili, tau=7, data=D, cens_covs=c("arm","edema"))
print(a3)

#-- Covariate dependent censoring via Cox (identity link)
a4 = ahreg(Surv(time,status) ~ arm + edema + bili, tau=7, data=D, cens_covs=c("arm","edema"), 
           link="identity")
print(a4)


}
\references{
#' Uno H, Tian L, Horiguchi M, Hattori S, Kehl KL. Regression models for average hazard. Biometrics. 2024; 80(2):ujae037. <doi: 10.1093/biomtc/ujae037>
}
\author{
Hajime Uno, Miki Horiguchi
}
