% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sentiment_analysis_grasp.R
\name{get_polarity}
\alias{get_polarity}
\title{Get Polarity from Grasp}
\usage{
get_polarity(grasp, sentence, comment_type, language)
}
\arguments{
\item{grasp}{The imported Grasp model, which is used to compute sentiment polarity.}

\item{sentence}{A character string representing the sentence for which sentiment polarity needs to be calculated.}

\item{comment_type}{A string that indicates the type of feedback (e.g., "verbeter" for improvement). This influences sentiment adjustment in Dutch language.}

\item{language}{A string indicating the language of the sentence ("nl" for Dutch, "en" for English, "de" for German, "fr" for French).}
}
\value{
A numeric value representing the sentiment polarity of the sentence. Positive values indicate positive sentiment, negative values indicate negative sentiment, and zero indicates neutral sentiment.
}
\description{
This function computes the polarity score for a given sentence using the Grasp sentiment analysis model. It applies specific logic based on the comment type (e.g., improvement suggestions) and language (Dutch, English, German, or French).
}
\details{
For Dutch sentences, the function applies specific transformations (such as removing certain words like "naar" and "gemaakt") before calculating sentiment. It also handles feedback sentences marked as "verbeter" (improvement suggestions) by adding the word "suboptimal" to adjust the sentiment analysis for improvement-type feedback.
}
