% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/joinSTOICH.R
\name{joinSTOICH}
\alias{joinSTOICH}
\title{Join STOICH Data Tables}
\usage{
joinSTOICH(dataTables)
}
\arguments{
\item{dataTables}{The STOICH data tables loaded using loadSTOICH.}
}
\value{
A single table merged from the individual STOICH data tables.
}
\description{
Joins the STOICH data tables from release files into a single table.
}
\examples{
\dontrun{
# Load the data
stoichData <- loadSTOICH(dataPath="C:/Users/example_user/STOICH_data_location")

# filtering by table such as:
stoichFiltered <- filterSTOICH(dataTables=stoichData,
                               var="TrophicMode",
                               val="photoautotroph",
                               condition="not equal") |>
  filterSTOICH(dataTables=stoichFiltered,
               var="Latitude",
               val=c(104.92, 103.01),
               condition="range")

stoichTable <- joinSTOICH(stoichFiltered)

}

}
\author{
Chad Petersen \email{cpetersen4@unl.edu}
}
