% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mem_multithreshold.R
\name{mem_multithreshold}
\alias{mem_multithreshold}
\title{Compute Moran's Eigenvector Maps across multiple distance thresholds}
\usage{
mem_multithreshold(
  distance.matrix = NULL,
  distance.thresholds = NULL,
  max.spatial.predictors = NULL
)
}
\arguments{
\item{distance.matrix}{Numeric distance matrix between spatial locations.}

\item{distance.thresholds}{Numeric vector of distance thresholds. Each threshold defines the maximum distance for spatial neighbors at that scale. Default: \code{NULL} (automatically computed with \code{\link[=default_distance_thresholds]{default_distance_thresholds()}}).}

\item{max.spatial.predictors}{Integer specifying the maximum number of spatial predictors to return. If the total number of MEMs exceeds this value, only the first \code{max.spatial.predictors} columns are returned. Default: \code{NULL} (no limit).}
}
\value{
Data frame with one row per observation (matching \code{distance.matrix} dimensions) and columns representing MEMs at different distance thresholds. Column names follow the pattern \verb{spatial_predictor_<threshold>_<number>} (e.g., "spatial_predictor_0_1", "spatial_predictor_1000_2").
}
\description{
Computes Moran's Eigenvector Maps (MEMs) using \code{\link[=mem]{mem()}} at multiple distance thresholds and combines them into a single data frame. This creates spatial predictors capturing patterns at different spatial scales.
}
\details{
This function generates spatial predictors at multiple spatial scales by computing MEMs at different distance thresholds. Different thresholds capture spatial patterns at different scales:
\itemize{
\item Smaller thresholds (e.g., 0) capture fine-scale spatial patterns
\item Larger thresholds capture broad-scale spatial patterns
}

\strong{Algorithm:}
\enumerate{
\item For each distance threshold, calls \code{\link[=mem]{mem()}} to compute MEMs
\item Each \code{\link[=mem]{mem()}} call applies the threshold, double-centers the matrix, and extracts positive eigenvectors
\item Combines all MEMs into a single data frame
\item Optionally limits the total number of predictors with \code{max.spatial.predictors}
}

The resulting MEMs are used as spatial predictors in \code{\link[=rf_spatial]{rf_spatial()}} to model spatial autocorrelation at multiple scales simultaneously.
}
\examples{
data(plants_distance)

# Compute MEMs for multiple distance thresholds
mems <- mem_multithreshold(
  distance.matrix = plants_distance,
  distance.thresholds = c(0, 1000, 5000)
)

# View structure
head(mems)
dim(mems)

# Check column names showing threshold and predictor number
colnames(mems)[1:6]

# Limit number of spatial predictors
mems_limited <- mem_multithreshold(
  distance.matrix = plants_distance,
  distance.thresholds = c(0, 1000, 5000),
  max.spatial.predictors = 20
)
dim(mems_limited)

}
\seealso{
\code{\link[=mem]{mem()}}, \code{\link[=rf_spatial]{rf_spatial()}}, \code{\link[=default_distance_thresholds]{default_distance_thresholds()}}, \code{\link[=double_center_distance_matrix]{double_center_distance_matrix()}}

Other spatial_analysis: 
\code{\link{filter_spatial_predictors}()},
\code{\link{mem}()},
\code{\link{moran}()},
\code{\link{moran_multithreshold}()},
\code{\link{pca}()},
\code{\link{pca_multithreshold}()},
\code{\link{rank_spatial_predictors}()},
\code{\link{residuals_diagnostics}()},
\code{\link{residuals_test}()},
\code{\link{select_spatial_predictors_recursive}()},
\code{\link{select_spatial_predictors_sequential}()}
}
\concept{spatial_analysis}
