% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculate_convex_hull_moment_matrix.R
\name{gen_momentsmatrix_constrained}
\alias{gen_momentsmatrix_constrained}
\title{Approximate continuous moment matrix over a numeric bounding box}
\usage{
gen_momentsmatrix_constrained(
  candidate_set,
  formula = ~.,
  n_samples_per_dimension = 10,
  user_provided_high_res_candidateset = FALSE
)
}
\arguments{
\item{candidate_set}{Candidate set}

\item{formula}{Default \code{~ .}. Model formula specifying the terms.}

\item{n_samples_per_dimension}{Default \code{10}. Number of samples to take per dimension when interpolating inside
the convex hull.}
}
\value{
A matrix of size \verb{p x p} (where \code{p} is the number of columns in the model matrix),
approximating the continuous moment matrix.
}
\description{
Treats the min–max range of each numeric column as a bounding box
and samples points uniformly to approximate the integral of the outer product of
the model terms, weighted by whether the point
is on the edge.
}
\keyword{internal}
