% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/autoplot.seroincidence.by.R
\name{autoplot.seroincidence.by}
\alias{autoplot.seroincidence.by}
\title{Plot \code{seroincidence.by} log-likelihoods}
\usage{
\method{autoplot}{seroincidence.by}(object, ncol = min(3, length(object)), ...)
}
\arguments{
\item{object}{a '"seroincidence.by"' object (from \code{\link[=est_seroincidence_by]{est_seroincidence_by()}})}

\item{ncol}{number of columns to use for panel of plots}

\item{...}{
  Arguments passed on to \code{\link[=autoplot.seroincidence]{autoplot.seroincidence}}
  \describe{
    \item{\code{log_x}}{should the x-axis be on a logarithmic scale (\code{TRUE})
or linear scale (\code{FALSE}, default)?}
  }}
}
\value{
a \code{"ggarrange"} object: a single or \code{\link[=list]{list()}} of \code{\link[ggplot2:ggplot]{ggplot2::ggplot()}}s
}
\description{
Plots log-likelihood curves by stratum, for \code{seroincidence.by} objects
}
\examples{
\donttest{
library(dplyr)
library(ggplot2)

xs_data <-
  sees_pop_data_pk_100

curve <-
  typhoid_curves_nostrat_100 \%>\%
  filter(antigen_iso \%in\% c("HlyE_IgA", "HlyE_IgG"))

noise <-
  example_noise_params_pk

est2 <- est_seroincidence_by(
  strata = c("catchment"),
  pop_data = xs_data,
  sr_params = curve,
  curve_strata_varnames= NULL,
  noise_strata_varnames = NULL,
  noise_params = noise,
  antigen_isos = c("HlyE_IgG", "HlyE_IgA"),
  #num_cores = 8, #Allow for parallel processing to decrease run time
  build_graph = TRUE
)

# Plot the log-likelihood curve
autoplot(est2)
}
}
