% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PlotPairLL.R
\name{LLRplot}
\alias{LLRplot}
\title{Scatter Plot of Pair LLRs}
\usage{
LLRplot(relx, rely, LLRU, fcl, top, RelCol, bgcol, Tassign = 0.5, Tfilter = -2)
}
\arguments{
\item{relx}{relationship to plot on the x-axis. One of 'PO', 'FS', 'HS',
'GP', 'FA', or 'HA'.}

\item{rely}{relationship to plot on the y-axis; as \code{relx}.}

\item{LLRU}{matrix with log10-likelihoods, already scaled by LL(U) for each
pair.}

\item{fcl}{focal relationship, sets outer circle colour of points.}

\item{top}{most likely relationship, sets inner filling colour of points.}

\item{RelCol}{named character vector with colours to use per relationship.}

\item{bgcol}{do background colour TRUE/FALSE.}

\item{Tassign}{assignment threshold, shown as grey square in bottom-left
corner and band along the diagonal.}

\item{Tfilter}{filter threshold, shown as dark grey square in bottom-left.}
}
\description{
Plot LLR(rely/U) against LLR(relx/U), for one combination of
  relationships, colour coded by fcl & top.
}
\details{
The background of the plot is coloured to match \code{relx} (bottom
  triangle) and \code{rely} (upper triangle).
}
\keyword{internal}
