% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getParDiffTree.R
\name{getParDiffTree}
\alias{getParDiffTree}
\title{Return table with parameter differences of a tree}
\usage{
getParDiffTree(tree, measure = "wald", normalize = FALSE)
}
\arguments{
\item{tree}{a semtree object.}

\item{measure}{a character. "wald" (default) gives the squared parameter
differences divided by their pooled standard errors. "test" gives the
contributions of the parameters to the test statistic."raw" gives the
absolute values of the parameter differences.}

\item{normalize}{logical value; if TRUE parameter differences of each split
are divided by sum of all differences the corresponding split. Set to FALSE
by default.}
}
\value{
A matrix containing parameter differences. The
matrix has \eqn{n} rows and \eqn{k} columns, where \eqn{n} is the number of
non-leaf nodes of the tree and \eqn{k} is the number of model parameters. The
rows are named by the node IDs as given \code{getNodeById} and the columns
are named as in \code{coef}.
}
\description{
Returns a table with some measure of parameter
differences between post-split nodes.
}
\author{
Manuel Arnold
}
