% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dots.R
\name{term_dot}
\alias{term_dot}
\title{Term-level Dot Plot for a Specific Cluster}
\usage{
term_dot(cluster_result, cluster = 1, value_type = "Padj", title = NULL)
}
\arguments{
\item{cluster_result}{A result list returned from \code{\link{cluster}}.}

\item{cluster}{Cluster ID (numeric) or term name (character) to plot.}

\item{value_type}{The name of the value column to visualize (e.g., "Padj" or "Pvalue").}

\item{title}{Optional title for the plot. If NULL, a default title is generated using the representative term.}
}
\value{
A \code{plotly} object representing the dot plot of terms.
}
\description{
Creates a dot plot of individual terms within a specified cluster, showing
their significance and number of genes.
}
\examples{
\donttest{
# Load example data
cluster_result <- readRDS(system.file("extdata", "cluster_result.rds",
                                      package = "richCluster"))
tdot <- term_dot(cluster_result, cluster = 1)
tdot
}
}
