% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bars.R
\name{term_bar}
\alias{term_bar}
\title{Term-level Bar Plot for a Specific Cluster}
\usage{
term_bar(cluster_result, cluster = 1, value_type = "Padj", title = NULL)
}
\arguments{
\item{cluster_result}{A result list returned by \code{\link{cluster}}.}

\item{cluster}{Cluster ID (numeric) or term name (character) to visualize.}

\item{value_type}{The column name to use for enrichment significance ("Padj" or "Pvalue").}

\item{title}{Optional plot title. If NULL, a default will be generated.}
}
\value{
A \code{plotly} object representing the bar plot.
}
\description{
Creates a horizontal bar plot showing enrichment values for individual terms
in a selected cluster.
}
\examples{
\donttest{
# Load example data
cluster_result <- readRDS(system.file("extdata", "cluster_result.rds",
                                      package = "richCluster"))
tbar <- term_bar(cluster_result, cluster = 1)
tbar
}
}
