% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sets.R
\name{overlap}
\alias{overlap}
\title{The overlap between calibrated C14 dates}
\usage{
overlap(
  y,
  er = c(),
  labels = c(),
  is.F = FALSE,
  res = 1000,
  cc = 1,
  postbomb = FALSE,
  deltaR = 0,
  deltaSTD = 0,
  thiscurve = NULL,
  BCAD = FALSE,
  normal = TRUE,
  t.a = 3,
  t.b = 4,
  cc.dir = NULL,
  threshold = 0,
  xlim = c(),
  cal.rev = TRUE,
  xlab = c(),
  yrby = 1,
  dist.col = rgb(0, 0, 0, 0.2),
  overlap.col = rgb(0, 0, 1, 0.4),
  overlap.border = NA,
  overlap.height = 1,
  talk = TRUE,
  visualise = TRUE,
  prob = 0.95,
  roundby = 1,
  bty = "n",
  yaxt = "n"
)
}
\arguments{
\item{y}{The set of radiocarbon dates. Alternatively, existing distributions can be provided as a list of distributions, e.g. already-calibrated distributions or distributions derived from age-model estimates.}

\item{er}{The lab errors of the radiocarbon dates}

\item{labels}{Labels to be printed for the distributions (optional).}

\item{is.F}{Set this to TRUE if the provided age and error are in the F14C timescale.}

\item{res}{The resolution to base the calculations on. Defaults to 1000 steps between the minimum and maximum cal BP (these are calculated from the total calendar age range of all calibrated distributions).}

\item{cc}{Calibration curve to use. Defaults to IntCal20 (\code{cc=1}).}

\item{postbomb}{Whether or not to use a postbomb curve. Required for negative radiocarbon ages.}

\item{deltaR}{Age offset (e.g. for marine samples).}

\item{deltaSTD}{Uncertainty of the age offset (1 standard deviation).}

\item{thiscurve}{As an alternative to providing cc and/or postbomb, the data of a specific curve can be provided (3 columns: cal BP, C14 age, error).}

\item{BCAD}{Which calendar scale to use. Defaults to cal BP, \code{BCAD=FALSE}.}

\item{normal}{Use the normal distribution to calibrate dates (default TRUE). The alternative is to use the t model (Christen and Perez 2016).}

\item{t.a}{Value a of the t distribution (defaults to 3).}

\item{t.b}{Value b of the t distribution (defaults to 4).}

\item{cc.dir}{Directory of the calibration curves. Defaults to where the package's files are stored (system.file), but can be set to, e.g., \code{cc.dir="curves"}.}

\item{threshold}{Report only values above a threshold. Defaults to \code{threshold=1e-6}.}

\item{xlim}{Age limits of the x-axis. Calculated automatically by default.}

\item{cal.rev}{Reverse the calendar axis. Defaults to TRUE.}

\item{xlab}{Label of the calendar age, defaults to BCAD or cal BP.}

\item{yrby}{Resolution in years. Defaults to \code{by=1}.}

\item{dist.col}{The colour of the individual (calibrated) distributions. Defaults to semi-transparent grey. Different colours can also be provided for the individual distributions.}

\item{overlap.col}{The colour of the overlap distribution.}

\item{overlap.border}{The colour of the border of the overlap distribution.}

\item{overlap.height}{The height of the overlap distribution.}

\item{talk}{Whether or not to report a summary of the spread.}

\item{visualise}{Whether or not to plot the individual distributions and the overlap.}

\item{prob}{Probability range to report. Defaults to \code{prob=0.95}.}

\item{roundby}{Number of decimals to report.}

\item{bty}{Draw a box around a box of a certain shape. Defaults to \code{bty="n"}.}

\item{yaxt}{Type of y-axis. Defaults to none drawn (\code{yaxt="n"}).}
}
\value{
The overlap between all calibrated probabilities as percentage, and a plot.
}
\description{
Calculates the amount of overlap (as percentage) between two or more calibrated radiocarbon dates. It does this by taking a sequence of calendar dates 'x' and for each calendar date find the calibrated distribution with the minimum height - this minimum height is taken as the overlap between the dates for that age. This is repeated for all 'x'. The sum of these heights is the overlap, which can reach values from 0 to 100\%.
}
\examples{
  y <- c(3820, 4430) # the C14 ages of a twig and a marine shell from a single layer
  er <- c(40, 40) # their lab errors
  overlap(y, er, cc=1:2, dist.col=3:4, labels=c("twig", "shell"))
  mydists <- list(caldist(130,20, cc=1), caldist(150,20, cc=0))
  overlap(mydists)
}
