% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/forms_matrix.R
\name{forms_matrix_get}
\alias{forms_matrix_get}
\title{Get a \code{forms_matrix} for Geomorphon Classification}
\usage{
forms_matrix_get(num_forms = 10, levels = get_forms_grass_enum())
}
\arguments{
\item{num_forms}{Integer. The number of forms to classify, one of \code{4}, \code{5},
\code{6}, or \code{10} (default).}

\item{levels}{Named integer with values between 0 and 10 corresponding to
form class labels. Default: \code{get_forms_grass_enum()}}
}
\value{
An object of class \code{forms_matrix}
}
\description{
Gets one of the internally defined forms matrices. A form matrix is defined
for the classic 10-form output (default; Jasiewicz & Stepinski, 2013) as well
as three simplified classes: 4-form, 5-form, and 6-form (Masetti et al.,
2018)
}
\details{
For creating custom classification systems see the \code{forms_matrix()} constructor.
}
\examples{

forms_matrix_get()

}
\references{
Stepinski, T., Jasiewicz, J., 2011, Geomorphons - a new approach to
classification of landform, in : Eds: Hengl, T., Evans, I.S., Wilson, J.P.,
and Gould, M., Proceedings of Geomorphometry 2011, Redlands, 109-112.
Available online:
\url{https://www.geomorphometry.org/uploads/pdf/pdf2011/StepinskiJasiewicz2011geomorphometry.pdf}

Jasiewicz, J., Stepinski, T., 2013, Geomorphons - a pattern recognition
approach to classification and mapping of landforms, Geomorphology, vol. 182,
147-156. (\doi{doi:10.1016/j.geomorph.2012.11.005})

Masetti, G., Mayer, L. A., & Ward, L. G. 2018, A Bathymetry- and
Reflectivity-Based Approach for Seafloor Segmentation. Geosciences, 8(1), 14.
(\doi{doi:10.3390/geosciences8010014})
}
\seealso{
\code{\link[=forms_matrix]{forms_matrix()}}
}
