% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/docsFileMethods.R, R/exportFiles.R,
%   R/importFiles.R, R/deleteFiles.R
\name{fileMethods}
\alias{fileMethods}
\alias{exportFiles}
\alias{importFiles}
\alias{deleteFiles}
\alias{exportFiles.redcapApiConnection}
\alias{importFiles.redcapApiConnection}
\alias{deleteFiles.redcapApiConnection}
\title{Export, Import, or Delete Files to a Field in a REDCap Project}
\usage{
exportFiles(
  rcon,
  record,
  field,
  event = NULL,
  dir = getwd(),
  file_prefix = TRUE,
  ...
)

importFiles(
  rcon,
  file,
  record,
  field,
  event,
  overwrite = TRUE,
  repeat_instance = NULL,
  ...
)

deleteFiles(rcon, record, field, event, ...)

\method{exportFiles}{redcapApiConnection}(
  rcon,
  record,
  field,
  event = NULL,
  dir = getwd(),
  file_prefix = TRUE,
  repeat_instance = NULL,
  ...
)

\method{importFiles}{redcapApiConnection}(
  rcon,
  file,
  record,
  field,
  event = NULL,
  overwrite = TRUE,
  repeat_instance = NULL,
  ...
)

\method{deleteFiles}{redcapApiConnection}(
  rcon,
  record = NULL,
  field = NULL,
  event = NULL,
  repeat_instance = NULL,
  ...
)
}
\arguments{
\item{rcon}{A \code{redcapConnection} object.}

\item{record}{\code{character(1)} or \code{integerish(1)}. The record ID in
which the desired file is stored.}

\item{field}{\code{character(1)}. The field name in which the file is stored.}

\item{event}{\code{character(1)} or \code{NULL}. The event name for the file.
This applies only to longitudinal projects.  If the event is not
supplied for a longitudinal project, the API will return an error message}

\item{repeat_instance}{\code{integerish(1)} or \code{NULL}. The repeat instance number of
the repeating event or the repeating instrument. When available in your
instance of REDCap, and passed as \code{NULL}, the API will assume a value of 1.}

\item{file}{\code{character(1)}. The file path to the file to be imported.}

\item{overwrite}{\code{logical(1)}.  When \code{FALSE}, the function checks
if a file already exists for that record.  If a file exists, the function
terminates to prevent overwriting.  When \code{TRUE}, no additional
check is performed.}

\item{dir}{\code{character(1)}. A directory/folder to which the file
will be saved. By default, the working directory is used.}

\item{file_prefix}{\code{logical(1)}.  Determines if a prefix is appended
to the file name.  The prefix takes the form \verb{[record_id]-[event_name]-[file_name]}.
The file name is always the same name of the file as it exists in REDCap.}

\item{...}{Arguments to pass to other methods}
}
\value{
\code{exportFiles} invisibly returns the file path to which the exported
file was saved.

\code{importFiles} invisibly returns \code{TRUE} when successful, or throws an
error if the import failed.

\code{deleteFiles} invisible returns \code{TRUE} when successful, or throws an
error if the deletion failed.
}
\description{
These methods enable to the user to export a file stored
in a project field, import a file, or delete an existing file.
}
\details{
These functions only export, import, or delete a single file.

When exporting, the file name cannot be changed; whatever name exists in
REDCap is the name that will be used. The record ID and event name
may be appended as a prefix.
}
\section{Functions}{
\itemize{
\item \code{exportFiles()}: Export a file from a REDCap project.

\item \code{importFiles()}: Import a file to a REDCap project.

\item \code{deleteFiles()}: Delete a file from a REDCap project.

}}
\examples{
\dontrun{
unlockREDCap(connections = c(rcon = "project_alias"), 
             url = "your_redcap_url", 
             keyring = "API_KEYs", 
             envir = globalenv())

save_to_dir <- tempdir()              

# Export a file
exportFiles(rcon, 
            record = 1, 
            field = "file_upload_test", 
            dir = save_to_dir)
            
# Export a file for a specific event
exportFiles(rcon, 
            record = 1, 
            field = "file_upload_test",
            event = "event_1_arm_1", 
            dir = save_to_dir)

# Import a file 
importFiles(rcon,
            file = "file_to_upload.txt" 
            record = 1, 
            field = "file_upload_test")
           
# Delete a file
deleteFiles(rcon, 
            record = 1, 
            field = "file_upload_test")
}

}
\seealso{
\code{\link[=exportFilesMultiple]{exportFilesMultiple()}}, \cr
\code{\link[=importFileToRecord]{importFileToRecord()}} (can create a record to receive the file if it does yet exist)
}
