% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{linearRegression}
\alias{linearRegression}
\title{Run a linear regression with optional ridge regression}
\usage{
linearRegression(matX, vecY, lambda = 0, intercept = TRUE)
}
\arguments{
\item{matX}{A matrix of explanatory variables (\sQuote{predictors}) in standard
R format (i.e. \sQuote{tall and skinny} to be transposed internally to MLPACK
format (i.e. \sQuote{short and wide}).}

\item{vecY}{A vector of dependent variables (\sQuote{responses})}

\item{lambda}{An optional ridge parameter, defaults to zero}

\item{intercept}{An optional boolean switch about an intercept, default is true.}
}
\value{
A vector with fitted values
}
\description{
Run a linear regression (with optional ridge regression)
}
\details{
This function performs a linear regression, and serves as a simple
test case for accessing an MLPACK function.
}
\examples{
suppressMessages(library(utils))
data("trees", package="datasets")
X <- with(trees, cbind(log(Girth), log(Height)))
y <- with(trees, log(Volume))
lmfit <- lm(y ~ X)
# summary(fitted(lmfit))
mlfit <- linearRegression(X, y)
# summary(mlfit)
all.equal(unname(fitted(lmfit)),  as.vector(mlfit))
}
