% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/workflow-freesurfer_recon_all.R
\name{cmd_run_freesurfer_recon_all}
\alias{cmd_run_freesurfer_recon_all}
\alias{cmd_run_freesurfer_recon_all_clinical}
\title{Workflow: 'FreeSurfer' surface reconstruction}
\usage{
cmd_run_freesurfer_recon_all(
  subject,
  mri_path,
  args = c("-all", "-autorecon1", "-autorecon2", "-autorecon3", "-autorecon2-cp",
    "-autorecon2-wm", "-autorecon2-pial"),
  work_path = NULL,
  overwrite = FALSE,
  command_path = NULL,
  dry_run = FALSE,
  verbose = dry_run
)

cmd_run_freesurfer_recon_all_clinical(
  subject,
  mri_path,
  work_path = NULL,
  overwrite = FALSE,
  command_path = NULL,
  dry_run = FALSE,
  verbose = dry_run,
  ...
)
}
\arguments{
\item{subject}{'RAVE' subject or subject ID}

\item{mri_path}{path to 'T1'-weighted 'MRI', must be a 'NIfTI' file}

\item{args}{type of workflow; see 'FreeSurfer' \code{recon-all} command
documentation; default choice is \code{'-all'} to run all workflows}

\item{work_path}{working directory; 'FreeSurfer' errors out when
working directory contains white spaces. By default, 'RAVE' automatically
creates a symbolic link to a path that contains no white space. Do not
set this input manually unless you know what you are doing}

\item{overwrite}{whether to overwrite existing work by deleting the folder;
default is false. In case of errors, set this to true to restart the
workflow; make sure you back up the files first.}

\item{command_path}{'FreeSurfer' home directory. In some cases, 'RAVE' might
not be able to find environment variable \code{'FREESURFER_HOME'}. Please
manually set the path if the workflow fails. Alternatively, you can manually
set FreeSurfer' home directory via 'RAVE' options
\code{\link[ravepipeline:raveio-option]{raveio_setopt("freesurfer_path", "/path/to/freesurfer/home")}}
prior to running the script}

\item{dry_run}{avoid running the code, but print the process instead}

\item{verbose}{print messages}

\item{...}{ignored}
}
\value{
A list of shell command set.
}
\description{
Runs 'FreeSurfer' \code{recon-all} command underneath; must have 'FreeSurfer'
installed.
}
\examples{

# Requires `FreeSurfer` and only works on MacOS or Linux
# as `FreeSurfer` does not support Windows

\dontrun{

# Create subject instance; strict=FALSE means it's OK if the subject
# is missing
subject <- as_rave_subject("YAEL/s01", strict = FALSE)

cmd_run_freesurfer_recon_all(
  subject = subject,
  mri_path = "/path/to/T1.nii.gz"
)

}
}
