% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.sim_data.R
\name{summary.sim_data}
\alias{summary.sim_data}
\title{Summary Of \code{sim_data} Object}
\usage{
\method{summary}{sim_data}(object, ...)
}
\arguments{
\item{object}{\code{sim_data} object; returned by \code{\link{initialise}} function}

\item{...}{further arguments passed to or from other methods;
currently none specified}
}
\value{
\code{summary.sim_data} object
}
\description{
Summary Of \code{sim_data} Object
}
\examples{

# data preparation
library(terra)

n1_small <- rast(system.file("input_maps/n1_small.tif", package = "rangr"))
K_small <- rast(system.file("input_maps/K_small.tif", package = "rangr"))

sim_data <- initialise(
  n1_map = n1_small,
  K_map = K_small,
  r = log(2),
  rate = 1 / 1e3
)
summary(sim_data)

}
