% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zstd_file_functions.R
\name{zstd_compress_file}
\alias{zstd_compress_file}
\title{Zstd file compression}
\usage{
zstd_compress_file(input_file, output_file, compress_level = qopt("compress_level"))
}
\arguments{
\item{input_file}{Path to the file to compress.}

\item{output_file}{Path for the compressed file.}

\item{compress_level}{The compression level used.}
}
\value{
No value is returned. The file is written to disk.
}
\description{
A utility function to compresses a file with zstd.
}
\examples{
infile <- tempfile()
writeBin(as.raw(1:5), infile)
outfile <- tempfile()
zstd_compress_file(infile, outfile, compress_level = 1)
stopifnot(file.exists(outfile))
}
