<!-- README.md is generated from README.Rmd. Please edit that file -->

# profile

<!-- badges: start -->

[![rcc](https://github.com/r-prof/profile/workflows/rcc/badge.svg)](https://github.com/r-prof/profile/actions) [![Codecov test coverage](https://codecov.io/gh/r-prof/profile/branch/main/graph/badge.svg)](https://app.codecov.io/gh/r-prof/profile?branch=main) [![CRAN status](https://www.r-pkg.org/badges/version/profile)](https://cran.r-project.org/package=profile)

<!-- badges: end -->

The goal of profile is to read and write files that contain run time profiling data. Currently, *profile* supports:

-   Files created by [`Rprof()`](https://www.rdocumentation.org/packages/utils/versions/3.4.3/topics/Rprof)
-   `.proto` files written by [`pprof -proto`](https://github.com/google/pprof), these can also be read by `pprof`

The data is available to the user for inspection and manipulation in a [documented stable data format](https://r-prof.github.io/profile/reference/validate_profile.html).

## Installation

You can install profile from GitHub with:

<pre class='chroma'>
<span class='c'># install.packages("remotes")</span>
<span class='nf'>remotes</span><span class='nf'>::</span><span class='nf'><a href='https://remotes.r-lib.org/reference/install_github.html'>install_github</a></span><span class='o'>(</span><span class='s'>"r-prof/profile"</span><span class='o'>)</span></pre>

## Example

This simple example converts an `.out` file generated by [`Rprof()`](https://rdrr.io/r/utils/Rprof.html) to the `.proto` format understood by `pprof`.

<pre class='chroma'>
<span class='nv'>rprof_path</span> <span class='o'>&lt;-</span> <span class='nf'><a href='https://rdrr.io/r/base/tempfile.html'>tempfile</a></span><span class='o'>(</span><span class='s'>"profile"</span>, fileext <span class='o'>=</span> <span class='s'>".out"</span><span class='o'>)</span>
<span class='nf'><a href='https://rdrr.io/r/utils/Rprof.html'>Rprof</a></span><span class='o'>(</span><span class='nv'>rprof_path</span>, line.profiling <span class='o'>=</span> <span class='kc'>TRUE</span><span class='o'>)</span>
<span class='nv'>x</span> <span class='o'>&lt;-</span> <span class='nf'><a href='https://rdrr.io/r/stats/Uniform.html'>runif</a></span><span class='o'>(</span><span class='m'>1e6</span><span class='o'>)</span>
<span class='nv'>res</span> <span class='o'>&lt;-</span> <span class='nf'><a href='https://rdrr.io/r/base/lapply.html'>vapply</a></span><span class='o'>(</span><span class='nv'>x</span>, <span class='kr'>function</span><span class='o'>(</span><span class='nv'>x</span><span class='o'>)</span> <span class='kr'>if</span> <span class='o'>(</span><span class='nv'>x</span> <span class='o'>&lt;</span> <span class='m'>0.5</span><span class='o'>)</span> <span class='nf'><a href='https://rdrr.io/r/base/MathFun.html'>sqrt</a></span><span class='o'>(</span><span class='nv'>x</span><span class='o'>)</span> <span class='kr'>else</span> <span class='nv'>x</span> <span class='o'>*</span> <span class='nv'>x</span>, <span class='nf'><a href='https://rdrr.io/r/base/numeric.html'>numeric</a></span><span class='o'>(</span><span class='m'>1</span><span class='o'>)</span><span class='o'>)</span>
<span class='nf'><a href='https://rdrr.io/r/utils/Rprof.html'>Rprof</a></span><span class='o'>(</span><span class='kc'>NULL</span><span class='o'>)</span>

<span class='kr'><a href='https://rdrr.io/r/base/library.html'>library</a></span><span class='o'>(</span><span class='nv'><a href='https://r-prof.github.io/profile/'>profile</a></span><span class='o'>)</span>
<span class='nv'>ds</span> <span class='o'>&lt;-</span> <span class='nf'><a href='https://r-prof.github.io/profile/reference/read_rprof.html'>read_rprof</a></span><span class='o'>(</span><span class='nv'>rprof_path</span><span class='o'>)</span>
<span class='nv'>ds</span>
<span class='c'>#&gt; Profile data: 28 samples</span>
<span class='nf'><a href='https://rdrr.io/r/base/names.html'>names</a></span><span class='o'>(</span><span class='nv'>ds</span><span class='o'>)</span>
<span class='c'>#&gt; [1] "meta"         "sample_types" "samples"      "locations"    "functions"   </span>
<span class='c'>#&gt; [6] ".rprof"</span>
<span class='nf'><a href='https://r-prof.github.io/profile/reference/read_rprof.html'>write_pprof</a></span><span class='o'>(</span><span class='nv'>ds</span>, <span class='nf'><a href='https://rdrr.io/r/base/file.path.html'>file.path</a></span><span class='o'>(</span><span class='nf'><a href='https://rdrr.io/r/base/tempfile.html'>tempdir</a></span><span class='o'>(</span><span class='o'>)</span>, <span class='s'>"1.pb.gz"</span><span class='o'>)</span><span class='o'>)</span></pre>

------------------------------------------------------------------------

## Code of Conduct

Please note that the profile project is released with a [Contributor Code of Conduct](https://r-prof.github.io/profile/CODE_OF_CONDUCT.html). By contributing to this project, you agree to abide by its terms.
