library(testthat)
library(pqrfe)

test_that("pqr works", {
n = 10
m = 5
d = 4
N = n*m
x = matrix(rnorm(d*N), ncol=d, nrow=N)
x1 = x
subj = rep(1:n, each=m)
alpha = rnorm(n)
beta = rnorm(d)
eps = rnorm(N)
y = as.vector(x %*% beta + rep(alpha, each=m) + eps)
m1 = pqr(x=x, y=y, subj=subj, tau=0.75, effect="fixed", c = 0)

expect_equal(length(as.numeric(m1$Tab_alpha$Coef)), n)
expect_true(all(as.numeric(m1$Tab_alpha$Coef) != 0))
})