% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DualPOSet.R
\name{DualPOSet}
\alias{DualPOSet}
\title{Dual of a poset.}
\usage{
DualPOSet(poset)
}
\arguments{
\item{poset}{An object of S4 class \code{POSet}.
Argument \code{poset} must be created by using any function contained in the package
aimed at building object of S4 class \code{POSet}
(e.g. \code{\link[=POSet]{POSet()}}, \code{\link[=LinearPOSet]{LinearPOSet()}}, \code{\link[=ProductPOSet]{ProductPOSet()}}, ...).}
}
\value{
The dual of the input poset, an object of S4 class \code{POSet}.
}
\description{
Computes the dual of the input poset.
}
\details{
Let \eqn{P=(V,\leq)} be a poset. Then its dual \eqn{P_d=(V,\leq_d)} is defined
by \eqn{a\leq_d b} if and only if \eqn{b\leq a} in \eqn{P}.
In other words, the dual of \eqn{P} is obtained by reversing its dominances.
}
\examples{
elems <- c("a", "b", "c", "d")

doms <- matrix(c(
  "a", "b",
  "c", "b",
  "b", "d"
), ncol = 2, byrow = TRUE)

pos1 <- POSet(elements = elems, dom = doms)

dual <- DualPOSet(pos1)

}
