% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/display.R, R/print-methods.R, R/print_md.R
\name{display.performance_model}
\alias{display.performance_model}
\alias{print.performance_model}
\alias{print_md.performance_model}
\alias{print_md.compare_performance}
\title{Print tables in different output formats}
\usage{
\method{display}{performance_model}(object, format = "markdown", digits = 2, caption = NULL, ...)

\method{print}{performance_model}(x, digits = 3, layout = "horizontal", ...)

\method{print_md}{performance_model}(
  x,
  digits = 2,
  caption = "Indices of model performance",
  layout = "horizontal",
  ...
)

\method{print_md}{compare_performance}(
  x,
  digits = 2,
  caption = "Comparison of Model Performance Indices",
  layout = "horizontal",
  ...
)
}
\arguments{
\item{object, x}{An object returned by one of the package's function, for
example \code{\link[=model_performance]{model_performance()}}, \code{\link[=compare_performance]{compare_performance()}}, or
\code{\link[=check_itemscale]{check_itemscale()}}.}

\item{format}{String, indicating the output format. Can be \code{"markdown"}
\code{"html"}, or \code{"tt"}. \code{format = "tt"} creates a \code{tinytable} object, which is
either printed as markdown or HTML table, depending on the environment. See
\code{\link[insight:export_table]{insight::export_table()}} for details.}

\item{digits}{Number of decimal places.}

\item{caption}{Table caption as string. If \code{NULL}, no table caption is printed.}

\item{...}{Arguments passed to other methods, e.g. \code{format()} (and thereby to
\code{\link[insight:format_table]{insight::format_table()}} or \code{\link[insight:export_table]{insight::export_table()}}. See related
documentation for details on available arguments. For example, to control
digits for information criteria like AIC or BIC, use \verb{ic_digits = <value>}.}

\item{layout}{Table layout (can be either \code{"horizontal"} or \code{"vertical"}).}
}
\value{
A character vector. If \code{format = "markdown"}, the return value
will be a character vector in markdown-table format.
}
\description{
Prints tables (i.e. data frame) in different output formats.
}
\details{
\code{display()} is useful when the table-output from functions, which is
usually printed as formatted text-table to console, should be formatted for
pretty table-rendering in markdown documents, or if knitted from rmarkdown
to PDF or Word files. See
\href{https://easystats.github.io/parameters/articles/model_parameters_formatting.html}{vignette}
for examples.
}
\section{Global Options to Customize Output when Printing}{

\itemize{
\item \code{easystats_display_format}: \verb{options(easystats_display_format = <value>)}
will set the default format for the \code{display()} methods. Can be one of
\code{"markdown"}, \code{"html"}, or \code{"tt"}.
}
}

\examples{
model <- lm(mpg ~ wt + cyl, data = mtcars)
mp <- model_performance(model)
display(mp)
display(mp, digits = 3, ic_digits = 4)
}
