% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pacu.R
\name{pacu_options}
\alias{pacu_options}
\title{Setting some options for the package}
\usage{
pacu_options(
  suppress.warnings = FALSE,
  suppress.messages = FALSE,
  apportion.size.multiplier = 1,
  minimum.coverage.fraction = 0.5
)
}
\arguments{
\item{suppress.warnings}{whether to suppress warning messages}

\item{suppress.messages}{whether to suppress  messages}

\item{apportion.size.multiplier}{a multiplier used to determine the size of the
apportioning polygons in the RITAS algorithm. A value of sqrt(2) will make polygons
approximately the same size as the harvest polygons. Smaller values increase the resolution
but also increase the computation time substantially.}

\item{minimum.coverage.fraction}{The minimum area of an apportioning polygon that needs to be covered
to conduct the apportioning operation.}
}
\value{
as a side effect it modifies the \sQuote{pacu.options} environment.
}
\description{
Set settings regarding messages and default behaviors of the package
}
\details{
Set pacu options
}
\examples{
\dontrun{
names(pacu.options)
pacu_options(suppress.warnings = FALSE)
pacu.options$suppress.warnings
}
}
