% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/opal.assign.R
\name{opal.assign}
\alias{opal.assign}
\title{Data or expression assignment}
\usage{
opal.assign(
  opal,
  symbol,
  value,
  variables = NULL,
  missings = FALSE,
  identifiers = NULL,
  id.name = NULL,
  updated.name = NULL,
  async = FALSE
)
}
\arguments{
\item{opal}{Opal object or list of opal objects.}

\item{symbol}{Name of the R symbol.}

\item{value}{The value to assign evaluated in the following order: a R expression, a function, a fully qualified name of a variable or a table in Opal or any other R object (data.frame, vector).}

\item{variables}{List of variable names or Javascript expression that selects the variables of a table (ignored if value does not refere to a table). See javascript documentation: http://wiki.obiba.org/display/OPALDOC/Variable+Methods}

\item{missings}{If TRUE, missing values will be pushed from Opal to R, default is FALSE. Ignored if value is an R expression.}

\item{identifiers}{Name of the identifiers mapping to use when assigning entities to R (from Opal 2.0).}

\item{id.name}{Add a vector with the given name representing the entity identifiers (from Opal 2.6). Default is NULL.}

\item{updated.name}{Add a vector with the given name representing the creation and last update timestamps (from Opal 2.6). Default is NULL.}

\item{async}{R script is executed asynchronously within the session (default is FALSE). If TRUE, the value returned is the ID of the command to look for (from Opal 2.1).}
}
\description{
Assign a Opal table, or a R expression or a R object to a R symbol in the current R session.
}
\examples{
\dontrun{
o <- opal.login('administrator','password', url='https://opal-demo.obiba.org')
# assign a list of variables from table CNSIM1
opal.assign(o, symbol="D", value="datashield.CNSIM1", variables=list("GENDER","LAB_TSC"))
# assign all the variables matching 'LAB' from table HOP of opal object o
opal.assign(o, symbol="D", value="datashield.CNSIM1", variables="name().matches('LAB_')")
# assign a function and call it
opal.assign.script(o, 'hello', quote(function(x) { print(paste0('Hello ', x , '!'))}))
opal.execute(o, "hello('Mr Bean')")
# push an arbitrary data frame to the R server
#opal.assign(o, "D", mtcars)
# push an arbitrary vector to the R server
#opal.assign(o, "C", mtcars$cyl)
opal.logout(o)
}
}
\seealso{
Other assignment functions: 
\code{\link{opal.assign.data}()},
\code{\link{opal.assign.resource}()},
\code{\link{opal.assign.script}()},
\code{\link{opal.assign.table}()},
\code{\link{opal.assign.table.tibble}()}
}
\concept{assignment functions}
