% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/opal.file.R
\name{opal.file_write}
\alias{opal.file_write}
\title{Write a file}
\usage{
opal.file_write(opal, source, destination = NULL)
}
\arguments{
\item{opal}{Opal object.}

\item{source}{Path to the file in the Opal file system (must exists and be accessible for the user).}

\item{destination}{Path to the destination file, relative to the R session workspace. Any required sub-folders will be created. If ommitted, file with same name will be written.}
}
\description{
Write a file from the Opal file system into the R session workspace.
}
\examples{
\dontrun{
o <- opal.login('administrator','password', url='https://opal-demo.obiba.org')
# user home expansion
opal.file_write(o, "~/spss/DatabaseTest.sav")
# rename file
opal.file_write(o, "/home/administrator/spss/DatabaseTest.sav", "x.sav")
# create sub-folder
opal.file_write(o, "/home/administrator/spss/DatabaseTest.sav", "test/x.sav")
opal.logout(o)
}
}
\seealso{
Other file functions: 
\code{\link{opal.file}()},
\code{\link{opal.file_cp}()},
\code{\link{opal.file_download}()},
\code{\link{opal.file_ls}()},
\code{\link{opal.file_mkdir}()},
\code{\link{opal.file_mkdir_tmp}()},
\code{\link{opal.file_mv}()},
\code{\link{opal.file_read}()},
\code{\link{opal.file_rm}()},
\code{\link{opal.file_unzip}()},
\code{\link{opal.file_upload}()}
}
\concept{file functions}
