% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vowel_space.R
\name{plot_vowel_space}
\alias{plot_vowel_space}
\title{Plot vowel space for speaker or speakers.}
\usage{
plot_vowel_space(
  vowel_data,
  speakers = NULL,
  vowel_colours = NULL,
  label_size = 4,
  means_only = TRUE,
  ellipses = FALSE,
  point_alpha = 0.1,
  facet = TRUE
)
}
\arguments{
\item{vowel_data}{data frame of vowel tokens as described above.}

\item{speakers}{list of speaker identifiers for speaker whose vowel space
is to be plotted.}

\item{vowel_colours}{a named list of vowel = colour entries to indicate
which colour to plot each vowel.}

\item{label_size}{It is often convenient to adjust the size of the labels (in
pts). Default is 4.}

\item{means_only}{whether to plot means only or all data points. Default:
TRUE.}

\item{ellipses}{whether to 95\% confidence ellipses. Only works if means_only
is FALSE. Default is FALSE.}

\item{point_alpha}{alpha value for data points if means_only is FALSE.}

\item{facet}{whether to plot distinct speakers in distinct facets. Default is
TRUE.}
}
\value{
\code{ggplot} object.
}
\description{
Given vowel data with the first column identifying speakers, the second
identifying vowels, the third containing F1 and the fourth containing F2
values, plot a vowel space using the speaker's mean values for each vowel.
Typically it is best to produce a plot from scratch. The primary purpose of
this function is to generate quick plots for interactive use, rather than to
produce plots for publication.
}
\examples{
# Plot mean vowel space across
plot_vowel_space(
  onze_vowels,
  speakers = NULL,
  vowel_colours = NULL,
  label_size = 4,
  means_only = TRUE,
  ellipses = FALSE,
  point_alpha = 0.1,
  facet = FALSE
 )
}
