% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/which_antichain.R
\name{which_antichain}
\alias{which_antichain}
\title{Return indices of first elements of the list, which are incomparable with preceding
elements.}
\usage{
which_antichain(x, distance = 0)
}
\arguments{
\item{x}{a list of integerish vectors}

\item{distance}{a non-negative integer, which specifies the allowed discrepancy between compared sets}
}
\value{
an integer vector of indices of selected (incomparable) elements.
}
\description{
The function returns indices of elements from the given list \code{x}, which are incomparable
(i.e., it is neither subset nor superset) with any preceding element. The first element
is always selected. The next element is selected only if it is incomparable with all
previously selected elements.
}
\author{
Michal Burda
}
