% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bin.time.R
\name{bin.time}
\alias{bin.time}
\title{Bin time-concentration data using quantile or algorithmic binning}
\usage{
bin.time(
  dat,
  nbins = "auto",
  bin.method = c("quantile", "jenks", "kmeans", "pretty", "sd", "equal", "density")
)
}
\arguments{
\item{dat}{A data frame containing PK data. Must include:
\itemize{
\item tad: time after dose
\item DVstd: standardized concentration (DV/dose)
\item EVID: optional event ID column used to filter observations (EVID == 0)
}}

\item{nbins}{Number of bins or "auto". If numeric with
\code{bin.method = "quantile"}, specifies equal-frequency bins. If "auto",
10 bins are used for quantile; otherwise binning is determined by
\code{vpc::auto_bin}. Numeric nbins for non-quantile methods is passed to
\code{vpc::auto_bin}.}

\item{bin.method}{Binning strategy (default = "quantile").
Available options are:
\itemize{
\item quantile: equal-frequency binning by empirical quantiles
\item jenks: natural breaks minimizing within-bin variance
\item kmeans, pretty, sd, equal, density: alternative binning
methods from vpc::auto_bin
}}
}
\value{
A list containing summary results of the time-concentration binning process.
}
\description{
Bins data by time using either equal-frequency (quantile) binning
or algorithmic binning methods.
}
\details{
Supports quantile-based binning and other data-driven methods
(jenks, kmeans, pretty, sd, equal, density), with optional automatic
bin count selection.
}
\examples{
dat <- Bolus_1CPT
dat <- nmpkconvert(dat)
dat <- calculate_tad(dat)
dat$DVstd <- dat$DV / dat$dose
bin.time(dat)

}
\seealso{
\code{\link[vpc:auto_bin]{vpc::auto_bin}}
}
\author{
Zhonghui Huang
}
