% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Clean.R
\name{flag_is_rebound}
\alias{flag_is_rebound}
\title{Flag if the shot attempt is a rebound attempt or not for all the shots in a
play-by-play}
\usage{
flag_is_rebound(play_by_play)
}
\arguments{
\item{play_by_play}{data.frame of play-by-play(s); see \code{\link[=gc_play_by_play]{gc_play_by_play()}}
and/or \code{\link[=wsc_play_by_play]{wsc_play_by_play()}} for reference; must be untouched by
non-nhlscraper functions; saves time if \code{\link[=flag_is_home]{flag_is_home()}} and/or}
}
\value{
data.frame with one row per event (play) and added \code{isRebound}
column
}
\description{
\code{flag_is_rebound()} flags if the shot attempt is a rebound attempt or not
for all the shots in a play-by-play.
}
\examples{
# May take >5s, so skip.
\donttest{
  test                      <- gc_play_by_play()
  test_is_home_flagged      <- flag_is_home(test)
  test_game_id_stripped     <- strip_game_id(test_is_home_flagged)
  test_time_period_stripped <- strip_time_period(test_game_id_stripped)
  test_is_rebound_flagged   <- flag_is_rebound(test_time_period_stripped)
}
}
