% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Clean.R
\name{count_goals_shots}
\alias{count_goals_shots}
\title{Count the as-of-event goal, shots on goal, Fenwick, and Corsi attempts and
differentials for all the events (plays) in a play-by-play by perspective}
\usage{
count_goals_shots(play_by_play)
}
\arguments{
\item{play_by_play}{data.frame of play-by-play(s); see \code{\link[=gc_play_by_play]{gc_play_by_play()}}
and/or \code{\link[=wsc_play_by_play]{wsc_play_by_play()}} for reference; must be untouched by
non-nhlscraper functions; saves time if \code{\link[=flag_is_home]{flag_is_home()}} has already been
called}
}
\value{
data.frame with one row per event (play) and added columns:
\code{homeGoals}, \code{awayGoals}, \code{homeSOG}, \code{awaySOG}, \code{homeFenwick},
\code{awayFenwick}, \code{homeCorsi}, \code{awayCorsi}, \code{goalsFor}, \code{goalsAgainst},
\code{SOGFor}, \code{SOGAgainst}, \code{fenwickFor}, \code{fenwickAgainst}, \code{corsiFor},
\code{corsiAgainst}, \code{goalDifferential}, \code{SOGDifferential},
\code{fenwickDifferential}, and \code{corsiDifferential}
}
\description{
\code{count_goals_shots()} counts the as-of-event goal, shots on goal, Fenwick,
and Corsi attempts and differentials for all the events (plays) in a
play-by-play by perspective.
}
\examples{
# May take >5s, so skip.
\donttest{
  test                     <- gc_play_by_play()
  test_is_home_flagged     <- flag_is_home(test)
  test_goals_shots_counted <- count_goals_shots(test_is_home_flagged)
}
}
