% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/set_dataset.R
\name{set_dataset}
\alias{set_dataset}
\title{set Site Information for Fossil Sites}
\usage{
set_dataset(
  x = NA,
  datasetid = NA_integer_,
  datasetname = NA_character_,
  database = NA_character_,
  doi = NA,
  recdatecreated = as.Date(character(1)),
  datasettype = NA_character_,
  age_range_old = NA_integer_,
  age_range_young = NA_integer_,
  age_units = NA_character_,
  notes = NA_character_,
  pi_list = NA,
  samples = NULL,
  specimens = NULL
)
}
\arguments{
\item{x}{object to be set as dataset,}

\item{datasetid}{dataset identifier}

\item{datasetname}{name of the dataset}

\item{database}{dataset where the dataset came from}

\item{doi}{DOI}

\item{recdatecreated}{date the dataset was created}

\item{datasettype}{type the dataset belongs to}

\item{age_range_old}{age range old}

\item{age_range_young}{age range young}

\item{age_units}{age units}

\item{notes}{notes}

\item{pi_list}{pi list}

\item{samples}{taxa objects}

\item{specimens}{specimens slot}
}
\value{
\code{dataset} object
}
\description{
Function to create new \code{dataset} objects for personal analysis.
The new object will not be uploaded to the database.
}
\examples{
{
# Create a dataset
my_dataset <- set_dataset(database = "EPD",
                    datasettype = "pollen",
                    notes = "my lake")
}
}
\author{
Socorro Dominguez \email{dominguezvid@wisc.edu}
}
