% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{h_check_fits_all_data_same}
\alias{h_check_fits_all_data_same}
\title{Predicate Indicating Whether \code{mmrm} Fits' Datasets Contain the Same
Observations}
\usage{
h_check_fits_all_data_same(fits)
}
\arguments{
\item{fits}{(\code{list})\cr list of \code{mmrm} fits.}
}
\value{
\code{TRUE} or \code{FALSE} indicating whether or not the datasets underlying
the elements of \code{fits} contain the same observations, and that each
dataset's columns are a subset of the next dataset's columns.
}
\description{
Checks a \code{list} of \code{mmrm} fits to see whether all their datasets contain the
same observations and that they only increase in columns from one dataset to
the next (i.e, columns are nested).
}
\details{
For efficiency, the inspection takes place in this order:
\enumerate{
\item \code{FALSE} is returned early if not all datasets have the same number of
rows.
\item \code{FALSE} is returned early if a dataset has a column not in the next
dataset.
\item The columns in common among adjacent datasets are sorted and compared
using \code{\link[=all.equal]{all.equal()}} with \code{check.attributes = FALSE}.
}

This function is more efficient than running \code{\link[=h_check_columns_nested]{h_check_columns_nested()}} on
all adjacent pairs and supplying the results to \code{\link[=all]{all()}}.
}
\seealso{
\code{\link[=h_check_columns_nested]{h_check_columns_nested()}}, which performs this check on two data
sets.
}
\keyword{internal}
