% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/auth-utils.R
\name{meetupr_auth_status}
\alias{meetupr_auth_status}
\alias{has_auth}
\title{Check all authentication methods and return details}
\usage{
meetupr_auth_status(client_name = get_client_name(), silent = FALSE)

has_auth(client_name = get_client_name())
}
\arguments{
\item{client_name}{A string representing the name of the client. By
default, it is set to \code{"meetupr"} and retrieved from the
\code{MEETUPR_CLIENT_NAME} environment variable.}

\item{silent}{logical, suppress messages if TRUE}
}
\value{
list with logicals and details for each method
}
\description{
Check all authentication methods and return details

Logical checker
}
\section{Functions}{
\itemize{
\item \code{has_auth()}: Check if any
authentication method is available

}}
\examples{
\dontrun{
# Check detailed authentication status with default client name
status_details <- meetupr_auth_status()

# Check detailed authentication status with a specific client name
status_details <- meetupr_auth_status(client_name = "custom_client")

# Suppress output messages
status_details <- meetupr_auth_status(silent = TRUE)
}
}
