% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{scale_mat_inplace}
\alias{scale_mat_inplace}
\title{Rescales a matrix in place.}
\usage{
scale_mat_inplace(M)
}
\arguments{
\item{M}{matrix of data (n x m)}
}
\value{
Returns a matrix of size (2 x m). The first row contains the column means. The second row contains the column standard dveiations. NOTE: The original matrix, M, is overwritten.
}
\description{
Rescales matrix so that each column has a mean of 0 and a standard deviation of 1.
The original matrix is overwritten in place. The function returns the means and standard deviations of each column used to rescale it.
}
\details{
The key advantage of this method is that it can be applied to very large matrices without having to make a second copy in memory and the original can still be restored using the saved information.
}
\examples{
m = matrix(rnorm(24, 1, 2),4, 6)
scale_params = scale_mat_inplace(m)
sweep(sweep(m,2,scale_params[2,],'*'),2,scale_params [1,], '+') # orginal matrix restored
}
