% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/package.R
\name{pkg_desc}
\alias{pkg_desc}
\alias{pkg_news}
\alias{pkg_code}
\alias{pkg_citation}
\alias{pkg_manual}
\title{Print the package description, news, citation, manual pages, and source code}
\usage{
pkg_desc(name = detect_pkg(), type = c("table", "dl"))

pkg_news(
  name = detect_pkg(),
  path = detect_news(name),
  recent = 1,
  toc = TRUE,
  number_sections = TRUE,
  ...
)

pkg_code(
  path = attr(detect_pkg(), "path"),
  pattern = "[.](R|c|h|f|cpp)$",
  toc = TRUE,
  number_sections = TRUE,
  link = TRUE
)

pkg_citation(name = detect_pkg())

pkg_manual(
  name = detect_pkg(),
  toc = TRUE,
  number_sections = TRUE,
  overview = TRUE,
  examples = list()
)
}
\arguments{
\item{name}{The package name (by default, it is automatically detected from
the \code{DESCRIPTION} file if it exists in the current working directory or
upper-level directories).}

\item{type}{The HTML tag for the description: \code{table} (\verb{<table>} with \verb{<tr>}
and \verb{<td>}) or \code{dl} (definition list \verb{<dl>} with \verb{<dt>} and \verb{<dd>}).}

\item{path}{For \code{\link[=pkg_news]{pkg_news()}}, path to the \code{NEWS.md} file. If empty, \code{\link[=news]{news()}}
will be called to retrieve the news entries. For \code{\link[=pkg_code]{pkg_code()}}, path to the
package root directory that contains \verb{R/} and/or \verb{src/} subdirectories.}

\item{recent}{The number of recent versions to show. By default, only the
latest version's news entries are retrieved. To show the full news, set
\code{recent = 0}.}

\item{toc}{Whether to add section headings to the document TOC (when TOC has
been enabled for the document).}

\item{number_sections}{Whether to number section headings (when sections are
numbered in the document).}

\item{...}{Other arguments to be passed to \code{\link[=news]{news()}}.}

\item{pattern}{A regular expression to match filenames that should be treated
as source code.}

\item{link}{Whether to add links on the file paths of source code. By
default, if a GitHub repo link is detected from the \code{BugReports} field of
the package \code{DESCRIPTION}, GitHub links will be added to file paths. You
can also provide a string template containing the placeholder \verb{\%s} (which
will be filled out with the file paths via \code{sprintf()}), e.g.,
\verb{https://github.com/yihui/litedown/blob/main/\%s}.}

\item{overview}{Whether to include the package overview page, i.e., the
\code{{name}-package.Rd} page.}

\item{examples}{A list of arguments to be passed to \code{\link[xfun:record]{xfun::record()}} to run
examples each help page, e.g., \code{list(dev = 'svg', dev.args = list(height = 6))}. If not a list (e.g., \code{FALSE}), examples will not be run.}
}
\value{
A character vector (HTML or Markdown) that will be printed as is
inside a code chunk of an R Markdown document.

\code{pkg_desc()} returns an HTML table containing the package metadata.

\code{pkg_news()} returns the news entries.

\code{pkg_code()} returns the package source code under the \verb{R/} and
\verb{src/} directories.

\code{pkg_citation()} returns the package citation in both the plain-text
and BibTeX formats.

\code{pkg_manual()} returns all manual pages of the package in HTML.
}
\description{
Helper functions to retrieve various types of package information that can be
put together as the full package documentation like a \pkg{pkgdown} website.
These functions can be called inside any R Markdown document.
}
\examples{
\dontrun{
litedown::pkg_desc()
litedown::pkg_news()
litedown::pkg_citation()
}
}
