% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/auxiliary.R
\name{simulXy}
\alias{simulXy}
\title{Simulate Model Matrix and Response Vector}
\usage{
simulXy(
  n,
  p,
  interc = 0,
  beta,
  family = gaussian(),
  prop = 0.1,
  lim.b = c(-3, 3),
  sigma = 1,
  size = 1,
  rho = 0,
  scale.data = TRUE,
  seed = NULL,
  X = NULL,
  dispersion = 0.1
)
}
\arguments{
\item{n}{Integer. Number of observations.}

\item{p}{Integer. Total number of covariates in the model matrix.}

\item{interc}{Numeric. Intercept to include in the linear predictor. Default is \code{0}.}

\item{beta}{Numeric vector of length \code{p}. Regression coefficients in the linear predictor.}

\item{family}{Distribution and link function. Allowed: \code{gaussian()}, \code{binomial()}, \code{poisson()} and , \code{Gamma()}. Can be a string, function, or family object.}

\item{prop}{Numeric in \code{[0,1]}. Used only if \code{beta} is missing; proportion of non-zero coefficients in \code{p}. Default is \code{0.1}.}

\item{lim.b}{Numeric vector of length 2. Range for coefficients if \code{beta} is missing. Default: \code{c(-3, 3)}.}

\item{sigma}{Standard deviation of Gaussian response. Default is \code{1}.}

\item{size}{Integer. Number of trials for binomial response. Default is \code{1}.}

\item{rho}{Numeric. Correlation coefficient for generating covariates. Used to create AR(1)-type covariance: \code{rho^|i-j|}. Default is \code{0}.}

\item{scale.data}{Logical. Whether to scale columns of the model matrix. Default is \code{TRUE}.}

\item{seed}{Optional. Integer seed for reproducibility.}

\item{X}{Optional. Custom model matrix. If supplied, it overrides the internally generated \code{X}.}

\item{dispersion}{Dispersion parameter of Gamma response. Default is \code{0.1}.}
}
\value{
A list with components:
\item{X}{Model matrix of dimension \code{n x p}}
\item{y}{Simulated response vector}
\item{beta}{True regression coefficients used}
\item{eta}{Linear predictor}
}
\description{
Generates synthetic covariates and response vector from a specified distribution for simulation studies or method validation.
}
\examples{
n <- 100; p <- 100
beta <- c(runif(10, -3, 3), rep(0, p - 10))
sim <- simulXy(n = n, p = p, beta = beta, seed = 1234)
o <- islasso(y ~ ., data = sim$data, family = gaussian())
summary(o, pval = 0.05)

}
\seealso{
\code{\link{islasso}}, \code{\link{islasso.path}}
}
\author{
Gianluca Sottile \email{gianluca.sottile@unipa.it}
}
