% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/structural-properties.R
\name{neighborhood.size}
\alias{neighborhood.size}
\title{Neighborhood of graph vertices}
\usage{
neighborhood.size(
  graph,
  order = 1,
  nodes = V(graph),
  mode = c("all", "out", "in"),
  mindist = 0
)
}
\arguments{
\item{graph}{The input graph.}

\item{order}{Integer giving the order of the neighborhood. Negative values
indicate an infinite order.}

\item{nodes}{The vertices for which the calculation is performed.}

\item{mode}{Character constant, it specifies how to use the direction of
the edges if a directed graph is analyzed. For \sQuote{out} only the
outgoing edges are followed, so all vertices reachable from the source
vertex in at most \code{order} steps are counted. For \sQuote{"in"} all
vertices from which the source vertex is reachable in at most \code{order}
steps are counted. \sQuote{"all"} ignores the direction of the edges. This
argument is ignored for undirected graphs.}

\item{mindist}{The minimum distance to include the vertex in the result.}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}

\code{neighborhood.size()} was renamed to \code{\link[=ego_size]{ego_size()}} to create a more
consistent API.
}
\keyword{internal}
