% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tree.R
\name{tree}
\alias{tree}
\alias{tree.map}
\alias{tree.bind}
\alias{tree.liftA2}
\alias{tree.expand}
\alias{tree.unfold}
\alias{tree.unfoldForest}
\alias{tree.sequence}
\title{Lazy rose trees}
\usage{
tree(root, children_ = list())

tree.map(f, x)

tree.bind(f, x)

tree.liftA2(f, x, y)

tree.expand(shrink, x)

tree.unfold(shrink, a)

tree.unfoldForest(shrink, a)

tree.sequence(trees)
}
\arguments{
\item{root}{the root of the rose tree}

\item{children_}{a list of children for the tree.}

\item{f}{a function for mapping, binding, or applying}

\item{x}{a tree to map or bind over}

\item{y}{a tree to map or bind over}

\item{shrink}{a shrinking function}

\item{a}{a value to unfold from}

\item{trees}{a tree, or list or structure potentially
containing trees to turn into a tree of
said structure.}
}
\description{
A rose tree is a type of multibranch tree.
This is hedgehog's internal implementation
of a lazy rose tree.
}
\details{
In general, one should not be required to
use any of the functions from this module
as the combinators in the gen module
should be expressive enough (if they're
not raise an issue).
}
