% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggseqeplot.R
\name{ggseqeplot}
\alias{ggseqeplot}
\title{Sequence Entropy Plot}
\usage{
ggseqeplot(
  seqdata,
  group = NULL,
  weighted = TRUE,
  with.missing = FALSE,
  linewidth = 1,
  linecolor = "Okabe-Ito",
  gr.linetype = FALSE
)
}
\arguments{
\item{seqdata}{State sequence object (class \code{stslist}) created with the \code{\link[TraMineR:seqdef]{TraMineR::seqdef}} function.}

\item{group}{If grouping variable is specified plot shows one line for each group}

\item{weighted}{Controls if weights (specified in \code{\link[TraMineR:seqdef]{TraMineR::seqdef}}) should be used. Default is \code{TRUE}, i.e. if available weights are used}

\item{with.missing}{Specifies if missing states should be considered when computing the entropy index (default is \code{FALSE}).}

\item{linewidth}{Specifies the with of the entropy line; default is \code{1}}

\item{linecolor}{Specifies color palette for line(s); default is \code{"Okabe-Ito"} which contains up to 9 colors (first is black).
if more than 9 lines should be rendered, user has to specify an alternative color palette}

\item{gr.linetype}{Specifies if line type should vary by group; hence only relevant if
group argument is specified; default is \code{FALSE}}
}
\value{
A line plot of entropy values at each sequence position. If stored as object the resulting list
object also contains the data (long format) used for rendering the plot.
}
\description{
Function for plotting the development of cross-sectional entropies across
sequence positions with \code{\link[ggplot2]{ggplot2}} \insertCite{wickham2016}{ggseqplot}
instead of base R's \code{\link[base]{plot}} function that is used by
\code{\link[TraMineR:seqplot]{TraMineR::seqplot}} \insertCite{gabadinho2011}{ggseqplot}.
Other than in \code{\link[TraMineR:seqHtplot]{TraMineR::seqHtplot}} group-specific entropy
lines are displayed in a common plot.
}
\details{
The function uses \code{\link[TraMineR:seqstatd]{TraMineR::seqstatd}}
to compute entropies. This requires that the input data (\code{seqdata})
are stored as state sequence object (class \code{stslist}) created with the
\code{\link[TraMineR:seqdef]{TraMineR::seqdef}} function.

The entropy values are plotted with \code{\link[ggplot2]{geom_line}}. The data
and specifications used for rendering the plot can be obtained by storing the
plot as an object. The appearance of the plot can be adjusted just like with
every other ggplot (e.g., by changing the theme or the scale using \code{+} and
the respective functions).
}
\examples{
# Use example data from TraMineR: actcal data set
data(actcal)

# We use only a sample of 300 cases
set.seed(1)
actcal <- actcal[sample(nrow(actcal), 300), ]
actcal.lab <- c("> 37 hours", "19-36 hours", "1-18 hours", "no work")
actcal.seq <- seqdef(actcal, 13:24, labels = actcal.lab)

# sequences sorted by age in 2000 and grouped by sex
# with TraMineR::seqplot (entropies shown in two separate plots)
seqHtplot(actcal.seq, group = actcal$sex)
# with ggseqplot (entropies shown in one plot)
ggseqeplot(actcal.seq, group = actcal$sex)
ggseqeplot(actcal.seq, group = actcal$sex, gr.linetype = TRUE)

# manual color specification
ggseqeplot(actcal.seq, linecolor = "darkgreen")
ggseqeplot(actcal.seq, group = actcal$sex,
           linecolor = c("#3D98D3FF", "#FF363CFF"))
}
\references{
\insertAllCited{}
}
\author{
Marcel Raab
}
