% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggpmisc.R
\docType{package}
\name{ggpmisc-package}
\alias{ggpmisc}
\alias{ggpmisc-package}
\title{ggpmisc: Miscellaneous Extensions to 'ggplot2'}
\description{
\if{html}{\figure{logo.png}{options: style='float: right' alt='logo' width='120'}}

Extensions to 'ggplot2' respecting the grammar of graphics paradigm. Statistics: locate and tag peaks and valleys; label plot with the equation of a fitted polynomial or other types of models including major axis, quantile and robust and resistant regression. Labels for P-value, R^2 or adjusted R^2 or information criteria for fitted models; parametric and non-parametric correlation; label with ANOVA table for fitted models; label with summary table for fitted models; annotations for multiple comparisons with adjusted P-values. Model fit classes for which suitable methods are provided by package 'broom' and 'broom.mixed' are supported as well as user-defined wrappers on model fit functions. Scales and stats to build volcano and quadrant plots based on outcomes, fold changes, p-values and false discovery rates.
}
\details{
Package 'ggpmisc' is over 10 years-old but its development has
  tracked the changes in 'ggplot2' making use of new features. Although
  fully compatible with 'ggplot2' (>= 4.0.0) its minimum requirement is
  'ggplot2' (>= 3.5.0). Currently 'ggpmisc' focus is on statistical
  annotations including fitted model equations and curves. Several special
  geometries used are from package 'ggpp', which is imported and re-exported
  in whole. These geometries and functions are documented in
  \code{\link[ggpp]{ggpp-package}}.

Extensions provided:
\itemize{
\item Stats for annotaions for parametric and non-parametric correlations.
\item Statistics for generating labels for fitted models, including
formatted equations. By default labels are R's plotmath expressions but LaTeX,
markdown and plain text formatted labels are optionally assembled.
\item Matching statistics for plotting curves and confidence bands bands for
the same fitted models.
\item Statistics for adding ANOVA tables and fitted model summaries as inset
tables in plots.
\item Statistic for adding annotations based on pairwise multiple
comparisons based on arbitrary contrasts and a choice of \emph{P} adjustment methods.
\item Statistics for locating and tagging "peaks" and "valleys" (local or global
 maxima and minima).
\item Functions and objects exported by \code{\link[ggpp]{ggpp-package}}.}

The stats for peaks and valleys are coded so as to work correctly both with
numeric and POSIXct variables mapped to the \emph{x} aesthetic.
}
\note{
The signatures of \code{stat_peaks()} and \code{stat_valleys()} from
  'ggpmisc' are identical to those of \code{stat_peaks()} and
  \code{stat_valleys()} from package 'ggspectra'. While those from 'ggpmisc'
  are designed for numeric or time objects mapped to the \emph{x} aesthetic,
  those from 'ggspectra' are for light spectra and expect a numeric variable
  describing wavelength mapped to the \emph{x} aesthetic.
}
\examples{

ggplot(lynx, as.numeric = FALSE) + geom_line() +
stat_peaks(colour = "red") +
  stat_peaks(geom = "text", colour = "red", angle = 66,
             hjust = -0.1, x.label.fmt = "\%Y") +
  ylim(NA, 8000)

formula <- y ~ poly(x, 2, raw = TRUE)
ggplot(cars, aes(speed, dist)) +
  geom_point() +
  stat_poly_line(formula = formula) +
  stat_poly_eq(use_label("eq", "R2", "P"),
               formula = formula,
               parse = TRUE) +
  labs(x = expression("Speed, "*x~("mph")),
       y = expression("Stopping distance, "*y~("ft")))

formula <- y ~ x
ggplot(PlantGrowth, aes(group, weight)) +
  stat_summary(fun.data = "mean_se") +
  stat_fit_tb(method = "lm",
              method.args = list(formula = formula),
              tb.type = "fit.anova",
              tb.vars = c(Term = "term", "df", "M.S." = "meansq",
                          "italic(F)" = "statistic",
                          "italic(p)" = "p.value"),
              tb.params = c("Group" = 1, "Error" = 2),
              table.theme = ttheme_gtbw(parse = TRUE)) +
  labs(x = "Group", y = "Dry weight of plants") +
  theme_classic()

}
\references{
Expanded on-line documentation for 'ggpmisc' at
\url{https://docs.r4photobiology.info/ggpmisc/} and source code at
\url{https://github.com/aphalo/ggpmisc} \cr
Expanded on-line documentation for 'ggpp' at
\url{https://docs.r4photobiology.info/ggpp/} and source code at
\url{https://github.com/aphalo/ggpp} \cr
Package 'ggplot2' documentation at
\url{https://ggplot2.tidyverse.org/}
}
\seealso{
Useful links:
\itemize{
  \item \url{https://docs.r4photobiology.info/ggpmisc/}
  \item \url{https://github.com/aphalo/ggpmisc}
  \item Report bugs at \url{https://github.com/aphalo/ggpmisc/issues}
}

}
\author{
\strong{Maintainer}: Pedro J. Aphalo \email{pedro.aphalo@helsinki.fi} (\href{https://orcid.org/0000-0003-3385-972X}{ORCID})

Other contributors:
\itemize{
  \item Kamil Slowikowski (\href{https://orcid.org/0000-0002-2843-6370}{ORCID}) [contributor]
  \item Samer Mouksassi \email{samermouksassi@gmail.com} (\href{https://orcid.org/0000-0002-7152-6654}{ORCID}) [contributor]
}

}
