% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kinship2_alignped2.R
\name{kinship2_alignped2}
\alias{kinship2_alignped2}
\title{Align pedigree - Process a set of siblings}
\usage{
kinship2_alignped2(x, dad, mom, level, horder, packed, spouselist)
}
\arguments{
\item{x}{Integer vector of sibling IDs to process}

\item{dad}{Integer vector of father indices}

\item{mom}{Integer vector of mother indices}

\item{level}{Integer vector indicating the generation level of each subject}

\item{horder}{Numeric vector of hint order for positioning subjects}

\item{packed}{Logical, if TRUE uses compact packing algorithm}

\item{spouselist}{Matrix defining spouse relationships}
}
\value{
A list containing the aligned pedigree structure for the sibling group:
  \item{nid}{Matrix of subject IDs at each level and position}
  \item{pos}{Matrix of horizontal positions}
  \item{fam}{Matrix of family indices}
  \item{n}{Vector of counts per level}
  \item{spouselist}{Updated spouse list}
}
\description{
This is an internal helper function for pedigree alignment. It processes a set
of siblings, ordering them according to hints and calling kinship2_alignped1
for each sibling. The results are merged together using kinship2_alignped3.
}
\keyword{internal}
