% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geneviewer.R
\name{GC_normalize}
\alias{GC_normalize}
\title{Normalize Gene Clusters in a Genomic Chart}
\usage{
GC_normalize(
  GC_chart,
  group = NULL,
  cluster = NULL,
  normalize = TRUE,
  preserve_gene_length = TRUE,
  gap = NULL,
  custom_gaps = list()
)
}
\arguments{
\item{GC_chart}{A chart object containing genomic data and clustering
information. The chart object must include a `series` component with data
for each cluster.}

\item{group}{Column name containing gene names to apply custom gaps to.}

\item{cluster}{A vector of cluster names to be normalized. If `NULL`, all
clusters in the `GC_chart` will be normalized.}

\item{normalize}{A logical value indicating whether to normalize the gene
positions within each cluster. Default is `TRUE`.}

\item{preserve_gene_length}{A logical vector indicating whether to preserve
the original gene lengths for each cluster. If a single value is provided,
it is recycled for all clusters.}

\item{gap}{A numeric vector specifying the proportion of the total length to
be used as the gap between genes in each cluster. The value must be between
0 and 1. If a single value is provided, it is recycled for all clusters. If
`NULL`, the gaps are calculated based on the actual spacing between the
genes in the original data.}

\item{custom_gaps}{A named list where each name corresponds to a gene name and
each value is a numeric factor by which to adjust the gap after that gene.}
}
\value{
The modified `GC_chart` object with normalized gene coordinates for
  the specified clusters.
}
\description{
This function normalizes the genomic coordinates of a set of genes within a
cluster, ensuring that the genes are evenly spaced along the entire range of
the cluster. The function allows for the option to preserve the original gene
lengths and to introduce customized gaps between the genes.
}
\examples{
genes_data <- data.frame(
  start = c(10, 90, 130, 10, 90, 130),
  end = c(40, 120, 160, 40, 120, 160),
  name = c('Gene 1', 'Gene 2', 'Gene 3','Gene 1', 'Gene 2', 'Gene 3'),
  group = c('A', 'B', 'C', 'A', 'B', 'C'),
  cluster =  c(1, 1, 1, 2, 2, 2)
)

GC_chart(genes_data, group = "group", cluster = "cluster", height = "150px") \%>\%
  GC_normalize(
    cluster = 2,
    preserve_gene_length = TRUE,
    gap = NULL
 )

}
